/**
* \file: VideoChannel.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample Video channel implementation
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_VIDEOCHANNEL_H_
#define BDCL_VIDEOCHANNEL_H_

#include<bdcl/AditVideoSink.h>

namespace adit { namespace bdcl {
class VideoChannel: public IAditVideoSinkCallbacks
{
public:

    VideoChannel(CoreCallbackDealer* inCallbackDealer);
    virtual ~VideoChannel();

    void configureCodec();

private:
    AditVideoSink* mVideoSink;

    /**
     * @brief Callback initiated by Video Endpoint to inform MC about rendering of
     * the first frame.
     */
    void onFirstFrameRendered();

    /** @brief Callback initiated by Baidu core to acknowledge the VideoEnocderInit call. The input parameters must be
     *         used to configure the Gstreamer pipline if initially configured parameters are denied by MD.
     */
    void onVideoEncoderInitDone(unsigned int inHeight, unsigned int inWidth, unsigned int inFramerate);

    /** @brief Callback initiated by Baidu core to after calling VideoEnocderInit, if MD not faces soome
     * problem to start the video decoder.
     */
    void onConnectException(carlifeConnectException inConnectException);

    /** @brief Callback initiated by ADIT to inform MC application about an error.
     */
    void onError(bdclErrorCodes inErrorCode);

};

} } /*namespace adit { namespace bdcl { */

#endif /* BDCL_VIDEOCHANNEL_H_ */
